<?php
require 'db.php';
require 'QueryBuilder.php';

$qb = new QueryBuilder($pdo);

// Tworzymy przykładowe tabele
$pdo->exec("DROP TABLE IF EXISTS users");
$pdo->exec("DROP TABLE IF EXISTS orders");

$pdo->exec("
CREATE TABLE users (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT,
    email TEXT,
    balance REAL
)");

$pdo->exec("
CREATE TABLE orders (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    user_id INTEGER,
    total REAL,
    status TEXT,
    FOREIGN KEY (user_id) REFERENCES users(id)
)");

echo "✅ Tabele utworzone.\n\n";

// Dodajmy kilku użytkowników
$qb->table('users')->insert(['name' => 'Jan Kowalski', 'email' => 'jan@example.com', 'balance' => 1000])->get();
$qb->table('users')->insert(['name' => 'Anna Nowak', 'email' => 'anna@example.com', 'balance' => 2000])->get();

// Dodajmy zamówienia
$qb->table('orders')->insert(['user_id' => 1, 'total' => 250.50, 'status' => 'paid'])->get();
$qb->table('orders')->insert(['user_id' => 1, 'total' => 300.00, 'status' => 'pending'])->get();
$qb->table('orders')->insert(['user_id' => 2, 'total' => 400.00, 'status' => 'paid'])->get();

echo "✅ Dane przykładowe dodane.\n\n";

// Przykład SELECT z JOIN
$results = $qb->table('users')
              ->select(['users.name', 'orders.total', 'orders.status'])
              ->join('orders', 'users.id', '=', 'orders.user_id')
              ->where('orders.status', '=', 'paid')
              ->orderBy('orders.total', 'DESC')
              ->get();

echo "📊 Wyniki zapytania JOIN:\n";
print_r($results);

// Przykład transakcji
try {
    echo "\n💰 Rozpoczynamy transakcję...\n";
    $qb->beginTransaction();

    $qb->table('users')
       ->update(['balance' => 900])
       ->where('id', '=', 1)
       ->get();

    $qb->table('users')
       ->update(['balance' => 2100])
       ->where('id', '=', 2)
       ->get();

    $qb->commit();
    echo "✅ Transakcja zakończona sukcesem.\n";
} catch (Exception $e) {
    $qb->rollBack();
    echo "❌ Błąd transakcji: " . $e->getMessage();
}

// Sprawdź aktualne dane użytkowników
$users = $qb->table('users')->select()->orderBy('id')->get();
echo "\n👥 Dane użytkowników po transakcji:\n";
print_r($users);

